/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.server;

import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWGuid;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWXMLData;
import java.lang.reflect.Array;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class VWFieldUtility {
    private static final long serialVersionUID = 464L;

    public static String _get_FILE_DATE() {
        return "$Date:   15 Oct 2008 19:18:58  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.6  $";
    }

    public static Object convertFieldValue(Object fieldValue, int fieldType, String fieldName, boolean isArray) throws VWException {
        try {
            if (fieldValue != null) {
                if (fieldValue.getClass().isArray()) {
                    if (!isArray) {
                        throw new VWException("vw.api.VWFieldNotArray", "Attempt to set array into non-array field {0}.", fieldName);
                    }
                    fieldValue = VWFieldUtility.convertArray(fieldValue, fieldType);
                } else if (fieldValue instanceof String && isArray) {
                    if ((fieldValue = VWFieldUtility.makeObjectFromString((String)fieldValue, fieldType, true)) == null) {
                        throw new VWException("vw.api.VWFieldInvalidArrayValue", "Attempt to set non-array value into array field {0}.", fieldName);
                    }
                    fieldValue = VWFieldUtility.convertArray(fieldValue, fieldType);
                } else {
                    if (isArray) {
                        throw new VWException("vw.api.VWFieldInvalidArrayValue", "Attempt to set non-array value into array field {0}.", fieldName);
                    }
                    fieldValue = VWFieldUtility.convertElement(fieldValue, fieldType);
                }
            }
        }
        catch (NumberFormatException e) {
            throw new VWException("vw.api.VWTypesDontMatch", "The type for new Value {0} does not match the VWFieldType {1} for {2}.", fieldValue, fieldType, fieldName);
        }
        catch (ParseException pe) {
            throw new VWException("vw.api.VWDateFormatParse", "Date format error: {0} at {1}: {2}.", pe.getMessage(), pe.getErrorOffset(), fieldValue);
        }
        return fieldValue;
    }

    protected static Object convertArray(Object array, int theType) throws VWException, NumberFormatException, ParseException {
        int length = Array.getLength(array);
        if (length > 0) {
            Object fieldValue = Array.get(array, 0);
            if (array.getClass().toString().startsWith("class [L") && VWFieldType.getVWFieldType(fieldValue) == theType && theType != 64 && theType != 32 && theType != 128 && theType != 512) {
                return array;
            }
        }
        Object[] newArray = new Object[length];
        for (int i = 0; i < length; ++i) {
            newArray[i] = VWFieldUtility.convertElement(Array.get(array, i), theType);
        }
        return newArray;
    }

    protected static Object convertElement(Object fieldValue, int theType) throws VWException, NumberFormatException, ParseException {
        if (fieldValue instanceof String && theType != 2) {
            fieldValue = VWFieldUtility.makeObjectFromString((String)fieldValue, theType);
        } else {
            int fieldType;
            if (fieldValue instanceof Short) {
                fieldValue = ((Short)fieldValue).intValue();
            }
            if (fieldValue instanceof Float) {
                fieldValue = new Double(((Float)fieldValue).doubleValue());
            }
            if (fieldValue instanceof Long) {
                fieldValue = new Double(((Long)fieldValue).doubleValue());
            }
            if (!VWFieldType.isValid(fieldType = VWFieldType.getVWFieldType(fieldValue))) {
                throw new VWException("vw.api.VWInvalidFieldTypeForObject", "The type for new Value is not a valid VWFieldType type {0}.", theType);
            }
            if (theType != fieldType) {
                fieldValue = VWFieldUtility.makeObjectFromString(fieldValue.toString(), theType);
            }
        }
        if (fieldValue instanceof VWAttachment) {
            fieldValue = fieldValue.toString();
        }
        if (fieldValue instanceof VWXMLData) {
            fieldValue = fieldValue.toString();
        }
        return fieldValue;
    }

    private static Object makeObjectFromString(String theString, int theType) throws VWException, NumberFormatException, ParseException {
        Object retVal = null;
        if (theString == null) {
            return null;
        }
        if (theString.length() == 0) {
            if (theType == 64) {
                return new VWParticipant("");
            }
            return null;
        }
        switch (theType) {
            case 1: {
                StringTokenizer iTk = new StringTokenizer(theString);
                retVal = new Integer(iTk.nextToken());
                break;
            }
            case 4: {
                StringTokenizer bTk = new StringTokenizer(theString);
                String strVal = bTk.nextToken();
                if (theString != null && (strVal.toUpperCase(Locale.ENGLISH).equals("TRUE") || strVal.toUpperCase(Locale.ENGLISH).equals("FALSE"))) {
                    retVal = Boolean.valueOf(strVal);
                    break;
                }
                throw new VWException("vw.api.VWBooleanParseError", "Invalid boolean value: {0}.", theString);
            }
            case 8: {
                StringTokenizer fTk = new StringTokenizer(theString);
                retVal = new Double(fTk.nextToken());
                break;
            }
            case 16: 
            case 256: {
                theString = theString.trim();
                StringTokenizer dTk = new StringTokenizer(theString, "\"");
                retVal = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss").parse(dTk.nextToken());
                break;
            }
            case 2: {
                retVal = theString;
                break;
            }
            case 64: {
                retVal = new VWParticipant();
                StringTokenizer pTk = new StringTokenizer(theString, "\"");
                ((VWParticipant)retVal).setParticipantName(pTk.nextToken());
                break;
            }
            case 32: {
                StringTokenizer aTk = new StringTokenizer(theString, "\"");
                retVal = new VWAttachment(aTk.nextToken());
                break;
            }
            case 128: {
                retVal = new VWXMLData();
                theString = theString.trim();
                StringTokenizer aTk = new StringTokenizer(theString, "\"");
                ((VWXMLData)retVal).setXML("\"" + aTk.nextToken() + "\"");
                break;
            }
            case 512: {
                StringTokenizer aTk = new StringTokenizer(theString, "\"");
                retVal = new VWGuid(aTk.nextToken());
                break;
            }
            default: {
                throw new VWException("vw.api.VWFieldTypeInvalidType", "The type passed is {0}, which is not a valid type.", String.valueOf(theType));
            }
        }
        return retVal;
    }

    /*
     * Unable to fully structure code
     */
    public static Object makeObjectFromString(String theString, int theType, boolean isArray) throws VWException, NumberFormatException, ParseException {
        block54: {
            block55: {
                retVal = null;
                if (isArray) break block55;
                retVal = VWFieldUtility.makeObjectFromString(theString, theType);
                break block54;
            }
            token = null;
            if (theType == 1 || theType == 8 || theType == 4) {
                strTk = new StringTokenizer(theString, "{}, \t\n\r", false);
            } else if (theType == 16 || theType == 256 || theType == 64 || theType == 32 || theType == 512) {
                strTk = new StringTokenizer(theString, "\"", true);
                while (strTk.hasMoreTokens() && !(token = strTk.nextToken()).equals("\"")) {
                }
                if (!token.equals("\"")) {
                    return null;
                }
            } else {
                strTk = new StringTokenizer(theString, "\"", true);
            }
            numElements = 0;
            switch (theType) {
                case 1: 
                case 4: 
                case 8: {
                    numElements = strTk.countTokens();
                    break;
                }
                case 2: 
                case 16: 
                case 32: 
                case 64: 
                case 128: 
                case 256: 
                case 512: {
                    numElements = VWFieldUtility.countQuotedStrings(theString);
                }
            }
            try {
                if (numElements <= 0) break block54;
                switch (theType) {
                    case 1: {
                        retVal = new Integer[numElements];
                        break;
                    }
                    case 2: {
                        retVal = new String[numElements];
                        break;
                    }
                    case 4: {
                        retVal = new Boolean[numElements];
                        break;
                    }
                    case 8: {
                        retVal = new Double[numElements];
                        break;
                    }
                    case 16: 
                    case 256: {
                        retVal = new Date[numElements];
                        break;
                    }
                    case 32: {
                        retVal = new VWAttachment[numElements];
                        break;
                    }
                    case 64: {
                        retVal = new VWParticipant[numElements];
                        break;
                    }
                    case 128: {
                        retVal = new VWXMLData[numElements];
                        break;
                    }
                    case 512: {
                        retVal = new VWGuid[numElements];
                    }
                }
                i = 0;
                while (strTk.hasMoreTokens()) {
                    if (i >= numElements) {
                        throw new VWException("vw.api.VWFieldTypeStringParseError", "More than expected number of values found found, expected {0}.", String.valueOf(numElements));
                    }
                    token = strTk.nextToken();
                    block16 : switch (theType) {
                        case 1: {
                            ((Integer[])retVal)[i] = (Integer)VWFieldUtility.makeObjectFromString(token, theType);
                            break;
                        }
                        case 2: {
                            if (!token.equals("\"")) {
                                while (!(token = strTk.nextToken()).equals("\"")) {
                                }
                            }
                            ((String[])retVal)[i] = "\"";
                            token = strTk.nextToken();
                            while (true) {
                                if (!token.equals("\"")) ** GOTO lbl76
                                if (strTk.hasMoreTokens() && (token = strTk.nextToken()).equals("\"")) {
                                    ((String[])retVal)[i] = ((String[])retVal)[i] + "\"\"";
                                } else {
                                    ((String[])retVal)[i] = ((String[])retVal)[i] + "\"";
                                    break block16;
lbl76:
                                    // 1 sources

                                    ((String[])retVal)[i] = ((String[])retVal)[i] + (String)VWFieldUtility.makeObjectFromString(token, theType);
                                }
                                token = strTk.nextToken();
                            }
                        }
                        case 4: {
                            ((Boolean[])retVal)[i] = (Boolean)VWFieldUtility.makeObjectFromString(token, theType);
                            break;
                        }
                        case 8: {
                            ((Double[])retVal)[i] = (Double)VWFieldUtility.makeObjectFromString(token, theType);
                            break;
                        }
                        case 16: 
                        case 256: {
                            ((Date[])retVal)[i] = (Date)VWFieldUtility.makeObjectFromString(token, theType);
                            token = strTk.nextToken();
                            if (!token.equals("\"")) {
                                throw new VWException("vw.api.VWFieldTypeMissingQuote", "Expected value to be terminated by a quote, found  <{0}>.", token);
                            }
                            while (!(token = strTk.nextToken()).equals("\"")) {
                            }
                            break;
                        }
                        case 32: {
                            ((VWAttachment[])retVal)[i] = (VWAttachment)VWFieldUtility.makeObjectFromString(token, theType);
                            token = strTk.nextToken();
                            if (!token.equals("\"")) {
                                throw new VWException("vw.api.VWFieldTypeMissingQuote", "Expected value to be terminated by a quote, found  <{0}>.", token);
                            }
                            while (!(token = strTk.nextToken()).equals("\"")) {
                            }
                            break;
                        }
                        case 64: {
                            ((VWParticipant[])retVal)[i] = (VWParticipant)VWFieldUtility.makeObjectFromString(token, theType);
                            token = strTk.nextToken();
                            if (!token.equals("\"")) {
                                throw new VWException("vw.api.VWFieldTypeMissingQuote", "Expected value to be terminated by a quote, found  <{0}>.", token);
                            }
                            while (!(token = strTk.nextToken()).equals("\"")) {
                            }
                            break;
                        }
                        case 128: {
                            if (!token.equals("\"")) {
                                while (!(token = strTk.nextToken()).equals("\"")) {
                                }
                            }
                            theXMLStr = new StringBuffer("");
                            theXMLStr.append("\"");
                            token = strTk.nextToken();
                            while (true) {
                                if (!token.equals("\"")) ** GOTO lbl126
                                if (strTk.hasMoreTokens() && (token = strTk.nextToken()).equals("\"")) {
                                    theXMLStr.append("\"\"");
                                } else {
                                    theXMLStr.append("\"");
                                    break block16;
lbl126:
                                    // 1 sources

                                    ((VWXMLData[])retVal)[i] = (VWXMLData)VWFieldUtility.makeObjectFromString(token, theType);
                                }
                                token = strTk.nextToken();
                            }
                        }
                        case 512: {
                            ((VWGuid[])retVal)[i] = (VWGuid)VWFieldUtility.makeObjectFromString(token, theType);
                            token = strTk.nextToken();
                            if (!token.equals("\"")) {
                                throw new VWException("vw.api.VWFieldTypeMissingQuote", "Expected value to be terminated by a quote, found  <{0}>.", token);
                            }
                            while (!(token = strTk.nextToken()).equals("\"")) {
                            }
                            break;
                        }
                    }
                    ++i;
                }
            }
            catch (NoSuchElementException e) {
                // empty catch block
            }
        }
        return retVal;
    }

    private static int countQuotedStrings(String theString) throws VWException {
        int quotedStringCount = 0;
        int len = theString.length();
        for (int i = 0; i < len; ++i) {
            int J;
            if (theString.charAt(i) != '\"') continue;
            boolean foundMatch = false;
            for (J = i + 1; J < len; ++J) {
                if (theString.charAt(J) != '\"') continue;
                if (J < len - 1 && theString.charAt(J + 1) == '\"') {
                    ++J;
                    continue;
                }
                ++quotedStringCount;
                foundMatch = true;
                break;
            }
            if (!foundMatch) {
                throw new VWException("vw.api.VWFieldTypeMisMatchedQuotes", "String contents not properly quoted.");
            }
            i = J;
        }
        return quotedStringCount;
    }

    public static String convertDateToString(Object dateObject) {
        if (dateObject == null || !(dateObject instanceof Date)) {
            return "";
        }
        return new SimpleDateFormat("MM/dd/yyyy HH:mm:ss").format((Date)dateObject);
    }
}

